/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.MOS65C02;
import jace.apple2e.RAM128k;
import jace.apple2e.SoftSwitches;
import jace.apple2e.VideoDHGR;
import jace.apple2e.VideoNTSC;
import jace.config.ClassSelection;
import jace.config.ConfigurableField;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.hardware.CardDiskII;
import jace.hardware.ConsoleProbe;
import jace.hardware.Joystick;
import jace.hardware.massStorage.CardMassStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Apple2e
extends Computer {
    static int IRQ_VECTOR = 1010;
    public Motherboard motherboard;
    @ConfigurableField(name="Slot 1")
    public ClassSelection card1 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 2")
    public ClassSelection card2 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 3")
    public ClassSelection card3 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 4")
    public ClassSelection card4 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 5")
    public ClassSelection card5 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 6")
    public ClassSelection card6 = new ClassSelection(Card.class, CardDiskII.class);
    @ConfigurableField(name="Slot 7")
    public ClassSelection card7 = new ClassSelection(Card.class, CardMassStorage.class);
    @ConfigurableField(name="Debug rom", description="Use debugger //e rom")
    public boolean useDebugRom = false;
    @ConfigurableField(name="Console probe", description="Enable console redirection (experimental!)")
    public boolean useConsoleProbe = false;
    private ConsoleProbe probe = new ConsoleProbe();
    @ConfigurableField(name="Helpful hints")
    public boolean enableHints = true;
    public Joystick joystick1;
    public Joystick joystick2;
    private List<RAMListener> hints = new ArrayList<RAMListener>();

    public Apple2e() {
        try {
            this.setMemory(new RAM128k());
            this.setCpu(new MOS65C02());
            this.setVideo(new VideoNTSC());
            for (SoftSwitches s : SoftSwitches.values()) {
                s.getSwitch().register();
            }
            this.joystick1 = new Joystick(0);
            this.joystick2 = new Joystick(1);
            this.reconfigure();
            this.reinitMotherboard();
        }
        catch (Throwable t) {
            System.err.println("Unable to initalize virtual machine");
            t.printStackTrace(System.err);
        }
    }

    @Override
    public String getName() {
        return "Computer (Apple //e)";
    }

    private void reinitMotherboard() {
        if (this.motherboard != null && this.motherboard.isRunning()) {
            this.motherboard.suspend();
        }
        this.motherboard = new Motherboard();
        this.motherboard.reconfigure();
        Motherboard.miscDevices.add(this.joystick1);
        Motherboard.miscDevices.add(this.joystick2);
    }

    @Override
    public void coldStart() {
        this.reinitMotherboard();
        this.reboot();
        for (SoftSwitches s : SoftSwitches.values()) {
            s.getSwitch().reset();
        }
        this.motherboard.resume();
    }

    public void reboot() {
        RAM r = this.getMemory();
        r.write(IRQ_VECTOR, (byte)0, false);
        r.write(IRQ_VECTOR + 1, (byte)0, false);
        r.write(IRQ_VECTOR + 2, (byte)0, false);
        this.warmStart();
    }

    @Override
    public void warmStart() {
        this.getCpu().suspend();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        for (SoftSwitches softSwitches : SoftSwitches.values()) {
            softSwitches.getSwitch().reset();
        }
        this.getMemory().configureActiveMemory();
        this.getVideo().configureVideoMode();
        this.getCpu().reset();
        for (Card card : this.getMemory().getAllCards()) {
            if (card == null) continue;
            card.reset();
        }
        this.motherboard.resume();
    }

    private void insertCard(Class<? extends Card> type, int slot) {
        if (this.getMemory().getCard(slot) != null) {
            if (this.getMemory().getCard(slot).getClass().equals(type)) {
                return;
            }
            this.getMemory().removeCard(slot);
        }
        if (type != null) {
            try {
                this.getMemory().addCard(type.newInstance(), slot);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void reconfigure() {
        try {
            if (this.useConsoleProbe) {
                this.probe.init(this);
            } else {
                this.probe.shutdown();
            }
            if (this.useDebugRom) {
                this.loadRom("jace/data/apple2e_debug.rom");
            } else {
                this.loadRom("jace/data/apple2e.rom");
            }
            this.insertCard((Class)this.card1.getValue(), 1);
            this.insertCard((Class)this.card2.getValue(), 2);
            this.insertCard((Class)this.card3.getValue(), 3);
            this.insertCard((Class)this.card4.getValue(), 4);
            this.insertCard((Class)this.card5.getValue(), 5);
            this.insertCard((Class)this.card6.getValue(), 6);
            this.insertCard((Class)this.card7.getValue(), 7);
            if (this.enableHints) {
                this.enableHints();
            } else {
                this.disableHints();
            }
            this.getMemory().configureActiveMemory();
        }
        catch (IOException ex) {
            Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void enableHints() {
        if (this.hints.isEmpty()) {
            this.hints.add(new RAMListener(RAMEvent.TYPE.READ, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

                @Override
                protected void doConfig() {
                    this.setScopeStart(64355);
                }

                @Override
                protected void doEvent(RAMEvent e) {
                    if (Apple2e.this.getCpu().getProgramCounter() != this.getScopeStart()) {
                        return;
                    }
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                                if (Apple2e.this.getCpu().getProgramCounter() >> 8 != 198) {
                                    return;
                                }
                                int row = 5;
                                for (String s : new String[]{"              Welcome to", "         _    __    ___   ____ ", "        | |  / /\\  / / ` | |_  ", "      \\_|_| /_/--\\ \\_\\_, |_|__ ", "", "    Java Apple Computer Emulator", "", "Brought to you by BLuRry and", "lots of other friendly folks at", "the COMP.SYS.APPLE2 usenet board", "", "Press F1 to insert disk in drive 1", "Press F2 to insert disk in drive 2", "Press F3 to insert hard disk in slot 7", "Press F4 to open configuration", "Press F5 to run binary program", "Press F8 to correct the aspect ratio", "Press F10 to open/close the debugger"}) {
                                    int addr = 1025 + VideoDHGR.calculateTextOffset(row++);
                                    for (char c : s.toCharArray()) {
                                        Apple2e.this.getMemory().write(addr++, (byte)(c | 0x80), false);
                                    }
                                }
                                while (Apple2e.this.getCpu().getProgramCounter() >> 8 == 198) {
                                    int x = (int)(Math.random() * 26.0) + 7;
                                    int y = (int)(Math.random() * 4.0) + 6;
                                    int addr = 1024 + VideoDHGR.calculateTextOffset(y) + x;
                                    byte old = Apple2e.this.getMemory().read(addr, false);
                                    for (char c : "+xX*+".toCharArray()) {
                                        if (Apple2e.this.getCpu().getProgramCounter() >> 8 != 198) break;
                                        Apple2e.this.getMemory().write(addr, (byte)(c | 0x80), false);
                                        Thread.sleep(100L);
                                    }
                                    Apple2e.this.getMemory().write(addr, old, false);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    });
                    t.start();
                }
            });
            this.hints.add(new RAMListener(RAMEvent.TYPE.READ, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

                @Override
                protected void doConfig() {
                    this.setScopeStart(42629);
                }

                @Override
                protected void doEvent(RAMEvent e) {
                    char c;
                    if (Apple2e.this.getCpu().getProgramCounter() != this.getScopeStart()) {
                        return;
                    }
                    String in = "";
                    for (int i = 512; i < 768 && (c = (char)(Apple2e.this.getMemory().read(i, false) & 0x7F)) != '\r'; ++i) {
                        in = in + c;
                    }
                    System.err.println("Intercepted command: " + in);
                }
            });
        }
        for (RAMListener hint : this.hints) {
            this.getMemory().addListener(hint);
        }
    }

    private void disableHints() {
        for (RAMListener hint : this.hints) {
            this.getMemory().removeListener(hint);
        }
    }
}

